#!/bin/bash

# 设置当前路径
currentPath=$(dirname "$0")
logPath="$currentPath/GIFTS_Update.log"

log() {
    echo $1
    echo "$(date '+%Y-%m-%d %H:%M:%S') - $1" >>"$logPath"
    if [ "$2" = "1" ]; then
        echo
        echo >>"$logPath"
    fi
}

# 打印时间
updatetime="升级时间$(date '+%Y-%m-%d %H:%M:%S')"
log "升级时间: $updatetime"

# 1、获取当前脚本文件的目录路径
log "[step1][当前sh执行路径] $currentPath"

# 2、获取当前目录下所有目录
log "[step2][当前所有目录列表]"
for dir in $currentPath; do
    log "$(basename "$dir")"
done

# 3、获取新版本目录名称，优先取GIFTS_Update_Info.txt的值，不存在则获取当前目录下GIFTS_开头的目录（TODO：考虑多个新版本的目录情况）
newVersionFolderName=""
versionPath="$currentPath/GIFTS_Update_Info.txt"

log "[step3][获取新版本目录]"
if [ -f "$versionPath" ]; then
    version=$(cat "$versionPath")
    log "GIFTS_Update_Info.txt存在，新版本为$version"
    newVersionFolderName="GIFTS_$version"
else
    log "GIFTS_Update_Info.txt不存在，查找GIFTS_开头"
    for dir in GIFTS_*; do
        newVersionFolderName="$dir"
        log "$newVersionFolderName"
        break
    done
fi

# 4、替换GIFTS目录
if [ ! -d "$currentPath/$newVersionFolderName" ]; then
    log "[step4]无GIFTS_x.x.x格式的新版本目录"
    log "[final][无需升级]"
    exit 0
else
    # 4.1执行替换GIFTS目录
    newVersionDir="$currentPath/$newVersionFolderName"
    targetVersionFolderName="GIFTS"
    targetVersionDir="$currentPath/$targetVersionFolderName"

    log "[step4][执行目录替换]"
    log "新版本路径: $newVersionDir"
    log "目标版本路径: $targetVersionDir"

    # 删除GIFTS目录
    log "[step4.1]执行删除GIFTS目录"
    count=0
    renameCount=0

    rename() {
        ((renameCount++))
        log "[安装进行中，请勿关闭]-第$renameCount次执行重命名GIFTS目录"
        mv "$newVersionDir" "$targetVersionFolderName" 2>>"$logPath"
        if [ -d "$targetVersionDir" ]; then
            log "[成功]重命名目录"
            if [ -f "$versionPath" ]; then
                log "删除$versionPath文件"
                rm "$versionPath" 2>>"$logPath"
            fi
            log "[step5]生成快捷方式"
            bash "$currentPath/install.sh"
            log "[step6]启动投易通"
            bash "$currentPath/run.sh"
            log "[final][升级成功]"
            exit 0
        elif [ $renameCount -lt 5 ]; then
            rename
        else
            log "[错误]重命名目录失败！待重命名目录$newVersionDir"
            log "[原因]文件夹或被占用"
            log "[指引1]打开$currentPath目录，双击执行update.sh文件进行手动升级"
            log "[指引2]请提供$currentPath目录下的GIFTS_Update.log日志文件给投易通经理协助升级"
            log "[final][升级失败][请查看上述指引处理]"
            exit 1
        fi
    }

    remove() {
        ((count++))
        log "[安装进行中，请勿关闭]-第$count次执行删除GIFTS目录"
        rm -rf "$targetVersionDir" 2>>"$logPath"
        if [ ! -d "$targetVersionDir" ]; then
            log "[成功]删除GIFTS目录"
            rename
        elif [ $count -lt 30 ]; then
            sleep 1
            remove
        else
            log "[错误]删除GIFTS目录失败！待删除目录$targetVersionDir"
            log "[原因]文件夹被占用，请在任务管理器中手动停止名为gf-easytrade进程"
            log "[指引1]打开$currentPath目录，双击执行update.sh文件进行手动升级"
            log "[指引2]请提供$currentPath目录下的GIFTS_Update.log日志文件给投易通经理协助升级"
            log "[final][升级失败][请查看上述指引处理]"
            exit 1
        fi
    }
    remove

fi
