#!/bin/bash

TARGET_ARCH=aarch64

# 设置当前路径
currentPath=$(dirname "$0")
logPath="$currentPath/GIFTS_Update.log"

# 记录日志
log() {
    echo $1
    echo "$(date '+%Y-%m-%d %H:%M:%S') - $1" >>"$logPath"
    if [ "$2" = "1" ]; then
        echo
        echo >>"$logPath"
    fi
}

# 用uname检查当前的cpu架构
cpu_arch=$(uname -m)

# 如果当前cpu架构与TARGET_ARCH不同，则退出脚本
if [ "$cpu_arch" != "$TARGET_ARCH" ]; then
    log "当前CPU架构为 $cpu_arch ，不支持安装 $TARGET_ARCH 版本。请下载 $cpu_arch 架构的版本进行安装。"
    exit 1
fi

# 运行install.sh
log "---运行install.sh---" 1

# 打印时间
updatetime="升级时间$(date '+%Y-%m-%d %H:%M:%S')"
log "$updatetime"

# Set the working directory
WORKING_DIR="$(pwd)"

# Set the path to the application
APP_PATH="$WORKING_DIR/GIFTS/gf_easytrade_gifts"

shortcutname=广发投易通专业投资版

# Set the path to the desktop entry file
DESKTOP_ENTRY_PATH="$HOME/.local/share/applications/$shortcutname.desktop"

# mkdir if DESKTOP_ENTRY_PATH folder not exist
if [ -d "$HOME/.local" ]; then
    mkdir $HOME/.local
fi

if [ -d "$HOME/.local/share" ]; then
    mkdir $HOME/.local/share
fi

if [ -d "$HOME/.local/share/applications" ]; then
    mkdir $HOME/.local/share/applications
fi

# 运行install.bat
log "---删除原快捷方式---" 1

# 删除绿色版的快捷方式
log "正在删除快捷方式: $DESKTOP_ENTRY_PATH"
rm "$DESKTOP_ENTRY_PATH"
if [ $? -eq 0 ]; then
    log "快捷方式已成功删除"
else
    log "未能删除快捷方式"
fi

log "创建快捷方式中..."

# Create the desktop entry file
cat <<EOF | tee -a "$DESKTOP_ENTRY_PATH"
[Desktop Entry]
Type=Application
Name=$shortcutname
Exec=env LD_LIBRARY_PATH="$WORKING_DIR/GIFTS/resources/addons/node-amaapi/linux-arm64/Release/lib" $APP_PATH --no-sandbox
Icon=easytrade
Terminal=false
Categories=Office;Finance;
Comment=EasyTrade for GF Securities
EOF

chmod 775 "$DESKTOP_ENTRY_PATH"

# 定义要移动的文件
ICON_FILE="easytrade.png"

# 定义要检查的目录列表
ICON_DIRECTORY="$HOME/.icons"

# 检查ICON_DIRECTORY目录是否存在，如果b不存在则创建
if [ ! -d "$ICON_DIRECTORY" ]; then
    mkdir "$ICON_DIRECTORY"
fi

# 移动ICON_FILE到ICON_DIRECTORY

log "正在移动图标到 $ICON_DIRECTORY"
mv "$ICON_FILE" "$ICON_DIRECTORY"
if [ $? -eq 0 ]; then
    log "图标已移动到 $ICON_DIRECTORY"
else
    log "未能移动图标到 $ICON_DIRECTORY"
fi

# Make the desktop entry file executable
chmod +x "$DESKTOP_ENTRY_PATH"
chmod +x ./*.sh

log "创建快捷方式成功"

# 检查是否存在以GIFTS_开头的文件
if ! find . -maxdepth 1 -type f -name 'GIFTS_*' | grep -q '^GIFTS_'; then
    # 如果不存在以GIFTS_开头的文件
    if [ ! -d "GIFTS" ]; then
        # 如果GIFTS目录不存在，则创建目录并移动文件
        find . -maxdepth 1 -type d -name 'GIFTS_*' -exec mv {} GIFTS \;
    fi
fi
