@echo off & setlocal enabledelayedexpansion
chcp 65001 > nul
pushd "%~dp0"
set "currentPath=%~dp0"
set "logPath=%currentPath%GIFTS_Update.log"

call :log ---运行install.bat--- 1

rem "获取当前时间"
for /F "tokens=2 delims==" %%G in ('wmic os get LocalDateTime /value') do set "dt=%%G"
set "year=%dt:~0,4%"
set "month=%dt:~4,2%"
set "day=%dt:~6,2%"
set "hour=%dt:~8,2%"
set "min=%dt:~10,2%"
set "sec=%dt:~12,2%"

rem "打印时间"
set "updatetime=升级时间%year%-%month%-%day% %hour%:%min%:%sec%"
call :log "%updatetime%" 1

rem "使用说明 install.bat targetpath [shortcutfolder] [shortcutname]"
rem "targetpath 要创建快捷方式的目标文件或目标目录"
call :FindGiftsDirectory result_dir result_ver
if defined result_dir (
    call :log 最大版本号目录:"%result_dir%"
    call :log 对应版本号:"%result_ver%"
) else (
    call :log 未找到GIFTS目录或符合GIFTS_数字.数字.数字格式的目录
    set "result_dir=GIFTS"
)

set "targetpath=%~dp0%result_dir%/gf_easytrade_gifts_uat.exe"
rem "shortcutfolder 快捷方式创建位置，为空默认为桌面"
set "shortcutfolder=%~2"
rem "shortcutname 快捷方式名称(打包时(pack.js文件)，生成install.bat文件时，名称需要跟进管理端或者交易端以及金融机构版、专业投资版进行替换)"
set "shortcutname=广发投易通金融机构版仿真"

rem "描述信息"
set "desc=EasyTrade for GF Securities"

rem "1、删除原快捷方式"
call :log 删除原快捷方式中... 1

set "oldShortcutname=C:\Users\Public\Desktop\广发投易通交易端仿真(银行专版).lnk"
call :log "正在删除快捷方式:%oldShortcutname%"
del "%oldShortcutname%"
if %errorlevel% equ 0 (
    call :log 快捷方式已成功删除
) else (
    call :log 未能删除快捷方式
)

rem "删除绿色版的快捷方式"
set "oldShortcutnameGreen=C:\Users\Public\Desktop\%shortcutname%.lnk"
call :log "正在删除快捷方式:%oldShortcutnameGreen%"
del "%oldShortcutnameGreen%"
if %errorlevel% equ 0 (
    call :log 快捷方式已成功删除
) else (
    call :log 未能删除快捷方式
)

rem "2、创建快捷方式"
call :log 创建快捷方式中...

if not defined targetpath goto :usage
if "%shortcutfolder%"=="" set "shortcutfolder=Desktop"
if "%shortcutname%"=="" set "shortcutname=shortcut"
mshta VBScript:Execute("Set a=CreateObject(""WScript.Shell""):Set b=a.CreateShortcut(a.SpecialFolders(""%shortcutfolder%"") & ""\%shortcutname%.lnk""):b.Description=""%desc%"":b.TargetPath=""%targetpath%"":b.WorkingDirectory=""%~dp0"":b.Save:close")

call :log 创建快捷方式成功

goto :eof

:usage
call :log 参数错误，参照以下格式
call :log "%~n0 [targetpath] [shortcutfolder] [shortcutname]"
pause

goto :eof

:log
if not "%2"=="" (
    echo.
    echo. >> "%logPath%"
)
echo %1
echo %1 >> "%logPath%"
exit /b


:: ==============================================
:: 函数：查找GIFTS目录或最大版本目录
:: 参数：
::   %1 - 返回目录名的变量名
::   %2 - 返回版本号的变量名（如果是版本目录）
:: ==============================================
:FindGiftsDirectory
setlocal enabledelayedexpansion
set "found_dir="
set "max_version="
set "max_version_dir="

:: 首先检查是否存在GIFTS目录
if exist "GIFTS\" (
    endlocal & (
        set "%1=GIFTS"
        set "%2="
    )
    goto :eof
)

:: 查找所有GIFTS_数字.数字.数字格式的目录
for /d %%d in ("GIFTS_*") do (
    set "dir_name=%%d"
    :: 验证目录名格式
    echo !dir_name! | findstr /r "^GIFTS_[0-9]+\.[0-9]+\.[0-9]+$" >nul
    if %errorlevel% equ 0 (
        for /f "tokens=1* delims=_" %%a in ("!dir_name!") do set "pure_ver=%%b"
        :: 验证版本号格式
        echo !pure_ver! | findstr /r "^[0-9]+\.[0-9]+\.[0-9]+$" >nul
        if %errorlevel% equ 0 (
            if not defined max_version (
                set "max_version=!pure_ver!"
                set "max_version_dir=!dir_name!"
            ) else (
                call :CompareVersions "!pure_ver!" "!max_version!" result
                if !result! == 1 (
                    set "max_version=!pure_ver!"
                    set "max_version_dir=!dir_name!"
                )
            )
        )
    )
)

:: 返回结果
endlocal & (
    if "%1" neq "" set "%1=%max_version_dir%"
    if "%2" neq "" set "%2=%max_version%"
)
goto :eof

:: ==============================================
:: 函数：比较两个版本号
:: 参数：
::   %1 - 版本1
::   %2 - 版本2
::   %3 - 返回结果的变量名
:: 返回值：
::   1: v1 > v2 | 0: 相等 | -1: v1 < v2
:: ==============================================
:CompareVersions
setlocal enabledelayedexpansion
set "v1=%~1"
set "v2=%~2"

:compare_loop
for /f "tokens=1* delims=." %%a in ("%v1%") do set "n1=%%a" & set "v1=%%b"
for /f "tokens=1* delims=." %%a in ("%v2%") do set "n2=%%a" & set "v2=%%b"

if %n1% gtr %n2% ( set "result=1" & goto :return )
if %n1% lss %n2% ( set "result=-1" & goto :return )

if defined v1 if defined v2 goto compare_loop

if defined v1 ( set "result=1" & goto :return )
if defined v2 ( set "result=-1" & goto :return )

set "result=0"

:return
endlocal & set "%~3=%result%"
goto :eof