@echo off
setlocal enabledelayedexpansion
chcp 65001 > nul
pushd "%~dp0"
set "currentPath=%~dp0"
set "logPath=%currentPath%GIFTS_Update.log"

rem "获取当前时间"
for /F "tokens=2 delims==" %%G in ('wmic os get LocalDateTime /value') do set "dt=%%G"
set "year=%dt:~0,4%"
set "month=%dt:~4,2%"
set "day=%dt:~6,2%"
set "hour=%dt:~8,2%"
set "min=%dt:~10,2%"
set "sec=%dt:~12,2%"

call :log ---升级投易通update.bat---

rem "打印时间"
set "updatetime=升级时间%year%-%month%-%day% %hour%:%min%:%sec%"
call :log "%updatetime%" 1

rem "1、获取当前bat文件的目录路径"

call :log [step1][当前bat执行路径]"%currentPath%" 1

rem "2、获取当前目录下所有目录"

call :log [step2][当前所有目录列表] 1
for /d %%i in ("*") do (
	call :log %%i
)



rem "3、获取新版本目录名称，优先取GIFTS_Update_Info.txt的值，不存在则获取当前目录下GIFTS_开头的目录（TODO：考虑多个新版本的目录情况）"
set "newVersionFolderName=''"
set "versionPath=%currentPath%GIFTS_Update_Info.txt"

call :log [step3][获取新版本目录] 1
if exist "%versionPath%" (
	set /p version=<"%versionPath%"
	call :log GIFTS_Update_Info.txt存在，新版本为!version!
	set "newVersionFolderName=GIFTS_!version!"
) else (
	call :log GIFTS_Update_Info.txt不存在，查找GIFTS_开头
	call :FindGiftsDirectory result_dir result_ver
	if defined result_dir (
		call :log 最大版本号目录:"!result_dir!"
		call :log 对应版本号:"!result_ver!"
		set "newVersionFolderName=!result_dir!"
	) else (
		call :log 未找到GIFTS目录或符合GIFTS_数字.数字.数字格式的目录
	)
)



rem "4、替换GIFTS目录"
if not exist "%newVersionFolderName%" (

	rem "新版本目录不存在则无需替换"
	call :log [step4]无GIFTS_x.x.x格式的新版本目录 1

	call :log [final][无需升级] 1

	pause
	goto :eof


) else (

	rem "4.1执行替换GIFTS目录"

	rem "新版本目录路径，如C:\GF-Easytrade-GIFTS-TEST\GIFTS_3.17.1"
	set "newVersionDir=%currentPath%%newVersionFolderName%"

	rem "目标版本目录名称"
	set "targetVersionFolderName=GIFTS"

	rem "目标版本目录路径 如 C:\GF-Easytrade-GIFTS-TEST\GIFTS"
	set "targetVersionDir=%currentPath%GIFTS"

	call :log [step4][执行目录替换] 1
	call :log 新版本路径:"!newVersionDir!"
	call :log 目标版本路径:"!targetVersionDir!"


	rem "删除GIFTS目录"
	call :log [step4.1]执行删除GIFTS目录 1

	set /a "count=0"
	set /a "renameCount=0"
	:remove
	set /a "count=!count!+1"
	timeout /t 1 /nobreak > nul
	call :log [安装进行中，请勿关闭]-第!count!次执行删除GIFTS目录
	rd /s /q "!targetVersionDir!" 2>> "%logPath%"
	if not exist "!targetVersionDir!" (

		rem "重命名GIFTS_x.x.x为GIFTS"
		call :log [成功]删除GIFTS目录

		call :log [step4.2]执行重命名将"!newVersionFolderName!"重命名为"!targetVersionFolderName!" 1
		call :rename

	) else (
		if not !count!==30 (
			goto :remove
		) else (
			call :log -
			call :log [错误]删除GIFTS目录失败！待删除目录"!targetVersionDir!"
			call :log [原因]文件夹被占用，请在任务管理器中手动停止名为"gf-easytrade"进程
			call :log -
			call :log [指引1]打开"!currentPath!"目录，双击执行"update.bat"文件进行手动升级
			call :log [指引2]请提供"!currentPath!"目录下的GIFTS_Update.log日志文件给投易通经理协助升级

			call :log [final][升级失败][请查看上述指引处理] 1
			pause
		)
	)

)

:log
if not "%2"=="" (
    echo.
    echo. >> "%logPath%"
)
echo %1
echo %1 >> "%logPath%"
exit /b

:rename
set /a "renameCount=!renameCount!+1"
timeout /t 1 /nobreak > nul
call :log [安装进行中，请勿关闭]-第!renameCount!次执行重命名GIFTS目录
ren "!newVersionDir!" "!targetVersionFolderName!" 2>> "%logPath%"
if exist "!targetVersionDir!" (
	call :log [成功]重命名目录

	rem "删除GIFTS_Update_Info.txt文件"
	if exist "%versionPath%" (
		call :log 删除"%versionPath%"文件
		del "%versionPath%" 2>> "%logPath%"
	)

	rem "5、生成快捷方式"
	call :log [step5]生成快捷方式 1
	call "%currentPath%install.bat"

	rem "6、启动投易通"
	call :log [step6]启动投易通 1
	call "%currentPath%run.bat"

	call :log [final][升级成功] 1
	exit /b
) else (

	if not !renameCount!==5 (
		call :rename
	) else (
		call :log [错误]重命名目录失败！待重命名目录"!newVersionDir!"
		call :log [原因]文件夹或被占用
		call :log -
		call :log [指引1]打开"!currentPath!"目录，双击执行"update.bat"文件进行手动升级
		call :log [指引2]请提供"!currentPath!"目录下的GIFTS_Update.log日志文件给投易通经理协助升级

		call :log [final][升级失败][请查看上述指引处理] 1
		pause
	)

)
exit /b

:: ==============================================
:: 函数：查找GIFTS目录或最大版本目录
:: 参数：
::   %1 - 返回目录名的变量名
::   %2 - 返回版本号的变量名（如果是版本目录）
:: ==============================================
:FindGiftsDirectory
setlocal enabledelayedexpansion
set "found_dir="
set "max_version="
set "max_version_dir="

:: 查找所有GIFTS_数字.数字.数字格式的目录
for /d %%d in ("GIFTS_*") do (
    set "dir_name=%%d"
    :: 验证目录名格式
    echo !dir_name! | findstr /r "^GIFTS_[0-9]+\.[0-9]+\.[0-9]+$" >nul
    if %errorlevel% equ 0 (
        for /f "tokens=1* delims=_" %%a in ("!dir_name!") do set "pure_ver=%%b"
        :: 验证版本号格式
        echo !pure_ver! | findstr /r "^[0-9]+\.[0-9]+\.[0-9]+$" >nul
        if %errorlevel% equ 0 (
            if not defined max_version (
                set "max_version=!pure_ver!"
                set "max_version_dir=!dir_name!"
            ) else (
                call :CompareVersions "!pure_ver!" "!max_version!" result
                if !result! == 1 (
                    set "max_version=!pure_ver!"
                    set "max_version_dir=!dir_name!"
                )
            )
        )
    )
)

:: 返回结果
endlocal & (
    if "%1" neq "" set "%1=%max_version_dir%"
    if "%2" neq "" set "%2=%max_version%"
)
goto :eof

:: ==============================================
:: 函数：比较两个版本号
:: 参数：
::   %1 - 版本1
::   %2 - 版本2
::   %3 - 返回结果的变量名
:: 返回值：
::   1: v1 > v2 | 0: 相等 | -1: v1 < v2
:: ==============================================
:CompareVersions
setlocal enabledelayedexpansion
set "v1=%~1"
set "v2=%~2"

:compare_loop
for /f "tokens=1* delims=." %%a in ("%v1%") do set "n1=%%a" & set "v1=%%b"
for /f "tokens=1* delims=." %%a in ("%v2%") do set "n2=%%a" & set "v2=%%b"

if %n1% gtr %n2% ( set "result=1" & goto :return )
if %n1% lss %n2% ( set "result=-1" & goto :return )

if defined v1 if defined v2 goto compare_loop

if defined v1 ( set "result=1" & goto :return )
if defined v2 ( set "result=-1" & goto :return )

set "result=0"

:return
endlocal & set "%~3=%result%"
goto :eof