@echo off
setlocal enabledelayedexpansion
chcp 65001 > nul
pushd "%~dp0"
set "currentPath=%~dp0"
set "logPath=%currentPath%GIFTS_Update.log"
call :log 启动投易通中...

rem "1、获取当前bat文件的目录路径"
call :log [当前bat执行路径]"%currentPath%"

rem "2、拼接exe地址 如C:\GF-Easytrade-GIFTS\GIFTS\gf_easytrade_gifts.exe"
call :FindGiftsDirectory result_dir result_ver
if defined result_dir (
    call :log 最大版本号目录:"%result_dir%"
    call :log 对应版本号:"%result_ver%"
) else (
    call :log 未找到GIFTS目录或符合GIFTS_数字.数字.数字格式的目录
    set "result_dir=GIFTS"
)
set "exePath=%currentPath%%result_dir%\gf_easytrade_gifts.exe"
call :log [投易通启动路径]"%exePath%"

if not exist "%exePath%" (
    call :log 启动投易通失败，文件不存在
) else (
    rem "3、执行exe"
    start "" "%exePath%"
    call :log 启动投易通成功
)

goto :eof

:log
if not "%2"=="" (
    echo.
    echo. >> "%logPath%"
)
echo %1
echo %1 >> "%logPath%"
exit /b

:: ==============================================
:: 函数：查找GIFTS目录或最大版本目录
:: 参数：
::   %1 - 返回目录名的变量名
::   %2 - 返回版本号的变量名（如果是版本目录）
:: ==============================================
:FindGiftsDirectory
setlocal enabledelayedexpansion
set "found_dir="
set "max_version="
set "max_version_dir="

:: 首先检查是否存在GIFTS目录
if exist "GIFTS\" (
    endlocal & (
        set "%1=GIFTS"
        set "%2="
    )
    goto :eof
)

:: 查找所有GIFTS_数字.数字.数字格式的目录
for /d %%d in ("GIFTS_*") do (
    set "dir_name=%%d"
    :: 验证目录名格式
    echo !dir_name! | findstr /r "^GIFTS_[0-9]+\.[0-9]+\.[0-9]+$" >nul
    if %errorlevel% equ 0 (
        for /f "tokens=1* delims=_" %%a in ("!dir_name!") do set "pure_ver=%%b"
        :: 验证版本号格式
        echo !pure_ver! | findstr /r "^[0-9]+\.[0-9]+\.[0-9]+$" >nul
        if %errorlevel% equ 0 (
            if not defined max_version (
                set "max_version=!pure_ver!"
                set "max_version_dir=!dir_name!"
            ) else (
                call :CompareVersions "!pure_ver!" "!max_version!" result
                if !result! == 1 (
                    set "max_version=!pure_ver!"
                    set "max_version_dir=!dir_name!"
                )
            )
        )
    )
)

:: 返回结果
endlocal & (
    if "%1" neq "" set "%1=%max_version_dir%"
    if "%2" neq "" set "%2=%max_version%"
)
goto :eof

:: ==============================================
:: 函数：比较两个版本号
:: 参数：
::   %1 - 版本1
::   %2 - 版本2
::   %3 - 返回结果的变量名
:: 返回值：
::   1: v1 > v2 | 0: 相等 | -1: v1 < v2
:: ==============================================
:CompareVersions
setlocal enabledelayedexpansion
set "v1=%~1"
set "v2=%~2"

:compare_loop
for /f "tokens=1* delims=." %%a in ("%v1%") do set "n1=%%a" & set "v1=%%b"
for /f "tokens=1* delims=." %%a in ("%v2%") do set "n2=%%a" & set "v2=%%b"

if %n1% gtr %n2% ( set "result=1" & goto :return )
if %n1% lss %n2% ( set "result=-1" & goto :return )

if defined v1 if defined v2 goto compare_loop

if defined v1 ( set "result=1" & goto :return )
if defined v2 ( set "result=-1" & goto :return )

set "result=0"

:return
endlocal & set "%~3=%result%"
goto :eof